% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCAR.R
\name{RCAR}
\alias{RCAR}
\alias{rcar}
\title{Regularized Class Association Rules for Multi-class Problems (RCAR+)}
\usage{
RCAR(
  formula,
  data,
  lambda = NULL,
  alpha = 1,
  glmnet.args = NULL,
  cv.glmnet.args = NULL,
  parameter = NULL,
  control = NULL,
  balanceSupport = FALSE,
  disc.method = "mdlp",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{formula}{A symbolic description of the model to be fitted. Has to be
of form \code{class ~ .} or \code{class ~ predictor1 + predictor2}.}

\item{data}{A data.frame or \link[arules:transactions-class]{arules::transactions} containing the training data.
Data frames are automatically discretized and converted to transactions with
\code{\link[=prepareTransactions]{prepareTransactions()}}.}

\item{lambda}{The amount of weight given to regularization during the
logistic regression learning process. If not specified (\code{NULL}) then
cross-validation is used to determine the best value (see Details section).}

\item{alpha}{The elastic net mixing parameter. \code{alpha = 1} is the lasso
penalty (default RCAR), and \code{alpha = 0} the ridge penalty.}

\item{cv.glmnet.args, glmnet.args}{A list of arguments passed on to
\code{\link[=cv.glmnet]{cv.glmnet()}} and \code{\link[=glmnet]{glmnet()}}, respectively. See Example section.}

\item{parameter, control}{Optional parameter and control lists for \code{\link[=apriori]{apriori()}}.}

\item{balanceSupport}{balanceSupport parameter passed to \code{\link[=mineCARs]{mineCARs()}}.}

\item{disc.method}{Discretization method for factorizing numeric input
(default: \code{"mdlp"}). See \code{\link[=discretizeDF.supervised]{discretizeDF.supervised()}} for more
supervised discretization methods.}

\item{verbose}{Report progress?}

\item{...}{For convenience, additional parameters are used to create the
\code{parameter} control list for \code{\link[=apriori]{apriori()}} (e.g., to specify the support and
confidence thresholds).}
}
\value{
Returns an object of class \link{CBA} representing the trained
classifier with the additional field \code{model} containing a list with the
following elements:

\item{all_rules}{all rules used to build the classifier, including the rules
with a weight of zero.}
\item{reg_model}{them multinomial logistic
regression model as an object of class \code{\link[=glmnet]{glmnet()}}.}
\item{cv}{contains the results for the cross-validation used determine
lambda.}
}
\description{
Build a classifier based on association rules mined for an input dataset and
weighted with LASSO regularized logistic regression following RCAR (Azmi, et
al., 2019). RCAR+ extends RCAR from a binary classifier to a multi-class
classifier and can use support-balanced CARs.
}
\details{
RCAR+ extends RCAR from a binary classifier to a multi-class classifier
using regularized multinomial logistic regression via \pkg{glmnet}.

If lambda is not specified (\code{NULL}) then cross-validation with the
largest value of lambda such that error is within 1 standard error of the
minimum is used to determine the best value (see \code{\link[=cv.glmnet]{cv.glmnet()}} also for how to
perform cross-validation in parallel).
}
\examples{
data("iris")

classifier <- RCAR(Species~., iris)
classifier

# inspect the rule base sorted by the larges class weight
inspect(sort(classifier$rules, by = "weight"))

# make predictions for the first few instances of iris
predict(classifier, head(iris))

# inspecting the regression model, plot the regularization path, and
# plot the cross-validation results to determine lambda
str(classifier$model$reg_model)
plot(classifier$model$reg_model)
plot(classifier$model$cv)

# show progress report and use 5 instead of the default 10 cross-validation folds.
classifier <- RCAR(Species~., iris, cv.glmnet.args = list(nfolds = 5), verbose = TRUE)
}
\references{
M. Azmi, G.C. Runger, and A. Berrado (2019). Interpretable
regularized class association rules algorithm for classification in a
categorical data space. \emph{Information Sciences,} Volume 483, May 2019.
Pages 313-331.
}
\author{
Tyler Giallanza and Michael Hahsler
}
