% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-select.R
\name{update_params}
\alias{update_params}
\title{Modify query parameters}
\usage{
update_params(x, ...)
}
\arguments{
\item{x}{a \code{FeatureLayer} or \code{Table} object}

\item{...}{key value pairs of query parameters and values.}
}
\value{
An object of the same class as \code{x}
}
\description{
\code{\link[=update_params]{update_params()}} takes named arguments and updates the query.
}
\examples{
\dontrun{
furl <- paste0(
  "https://services.arcgis.com/P3ePLMYs2RVChkJx/ArcGIS/rest/services/",
  "USA_Major_Cities_/FeatureServer/0"
)

flayer <- arc_open(furl)
update_params(flayer, outFields = "NAME")
}
}
