% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hzBoundary.R
\name{hzTopographyCodeToOffset}
\alias{hzTopographyCodeToOffset}
\title{Convert Horizon Boundary Topography to Vertical Offset}
\usage{
hzTopographyCodeToOffset(
  x,
  codes = c("smooth", "wavy", "irregular", "broken"),
  offset = c(0, 4, 8, 12)
)
}
\arguments{
\item{x}{vector of boundary topography codes to be converted}

\item{codes}{character vector of topography terms ('smooth') or codes ('S'), case insensitive, see details}

\item{offset}{vertical offset (depth units) used to create "chevron" effect}
}
\value{
vector of vertical offsets with same length as \code{x}
}
\description{
This function will convert USDA-NCSS horizon boundary topography codes into a vertical offset, suitable for use in \code{plotSPC}. Default values are reasonable starting points for encoding smooth, wavy, irregular, or broken style horizon boundary topography as defined in \href{https://nrcspad.sc.egov.usda.gov/DistributionCenter/product.aspx?ProductID=991}{Field Book for Describing and Sampling Soils, version 3.0}.
}
\details{
Additional examples are available in the \href{https://ncss-tech.github.io/AQP/aqp/hz-boundaries.html}{Visualization of Horizon Boundaries tutorial}. Missing data in \code{x} (NA) or codes that are not defined in \code{codes} are returned with an offset of 0.

Either format (or mixture) are accepted, case insensitive:
\itemize{
\item terms: \code{c('smooth', 'wavy', 'irregular', 'broken')}
\item coded values: \code{c('s', 'w', 'i', 'b')}
}
}
\references{
\href{https://nrcspad.sc.egov.usda.gov/DistributionCenter/product.aspx?ProductID=991}{Field Book for Describing and Sampling Soils, version 3.0}
}
\seealso{
\code{\link{plotSPC}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
