% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootval.R
\name{bootval}
\alias{bootval}
\title{Bootstrap-derived Shrinkage After Estimation}
\usage{
bootval(dataset, model, N, sdm, int = TRUE, int.adj)
}
\arguments{
\item{dataset}{a dataset for regression analysis. Data should be in the form
of a matrix, with the outcome variable as the final column.
Application of the \code{\link{datashape}} function beforehand
is recommended, especially if categorical predictors are present.
For regression with an intercept included a column vector of
1s should be included before the dataset (see examples).}

\item{model}{type of regression model. Either "linear" or "logistic".}

\item{N}{the number of times to replicate the bootstrapping process}

\item{sdm}{a shrinkage design matrix. For examples, see \code{\link{ols.shrink}}}

\item{int}{logical. If TRUE the model will include a regression intercept.}

\item{int.adj}{logical. If TRUE the regression intercept will be re-estimated
after shrinkage of the regression coefficients.}
}
\value{
\code{bootval} returns a list containing the following:

\item{raw.coeff}{the raw regression model coefficients, pre-shrinkage.}

\item{shrunk.coeff}{the shrunken regression model coefficients}

\item{lambda}{the mean shrinkage factor over N bootstrap replicates}

\item{N}{the number of bootstrap replicates}

\item{sdm}{the shrinkage design matrix used to apply the shrinkage
  factor(s) to the regression coefficients}
}
\description{
Shrink regression coefficients using a bootstrap-derived shrinkage factor.
}
\details{
This function applies bootstrapping to a dataset in order to derive a shrinkage
factor and apply it to the regression coefficients. Regression coefficients are
estimated in a bootstrap sample, and then a shrinkage factor is estimated using
the input data. The mean of N shrinkage factors is then applied to the original
regression coeffients, and the regression intercept may be re-estimated.

This process can currently be applied to linear or logistic regression models.
}
\examples{
## Example 1: Linear regression using the iris dataset
data(iris)
iris.data <- as.matrix(iris[, 1:4])
iris.data <- cbind(1, iris.data)
sdm1 <- matrix(c(0, 1, 1, 1), nrow = 1)
set.seed(777)
bootval(dataset = iris.data, model = "linear", N = 200, sdm = sdm1,
int = TRUE, int.adj = TRUE)

## Example 2: logistic regression using a subset of the mtcars data
data(mtcars)
mtc.data <- cbind(1,datashape(mtcars, y = 8, x = c(1, 6, 9)))
head(mtc.data)
set.seed(777)
bootval(dataset = mtc.data, model = "logistic", N = 500)
}

