% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createStudy.R
\name{create-study}
\alias{create-study}
\alias{createStudy}
\alias{createStudyAPI}
\title{Create an empty Antares study}
\usage{
createStudy(path, study_name = "my_study", antares_version = "8.2.0")

createStudyAPI(
  host,
  token = NULL,
  study_name = "my_study",
  antares_version = "8.2.0",
  ...
)
}
\arguments{
\item{path}{Path where to create study, it should be an empty directory,
if it doesn't exist, it'll be created.}

\item{study_name}{Name of the study.}

\item{antares_version}{Antares number version.}

\item{host}{Host of AntaREST server API.}

\item{token}{API personnal access token.}

\item{...}{Other query parameters passed to POST request.}
}
\value{
Result of \code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}} or \code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPathAPI()}} accordingly.
}
\description{
Create study on disk or with AntaREST server through the API.
}
\section{Warning}{

From \strong{Antares version 9.0} onwards, versioning is only done with one number
for the major version number and a two-digit number for the minor
version number (e.g. 9.0, 9.12, 10.58, ...).
}

\examples{
\dontrun{

# with default values 
createStudy("path/to/simulation", 
  study_name = "my_study", 
  antares_version = "8.2.0")
  
# with Antares study version >= 9 (max 2 digits, ex : "9.15")  
createStudy("path/to/simulation", 
  study_name = "my_study", 
  antares_version = "9.15")

}
}
