% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALE_methods.R
\name{invert_probs}
\alias{invert_probs}
\title{Invert ALE Probabilities}
\usage{
invert_probs(ale_obj, rename_y_col = NULL, force = FALSE)
}
\arguments{
\item{ale_obj}{An object of class \code{ALE}.}

\item{rename_y_col}{character(1). If provided, renames the y outcome column. When probabilities are inverted, the name of the outcome column often needs to change for more intuitive interpretability. The default \code{NULL} does not change the outcome column name.}

\item{force}{logical(1). If \code{TRUE}, inverts probabilities even if they have already been inverted once before (reverting them). The default \code{FALSE} will error if probabilities have already been inverted.}
}
\value{
An updated \code{ALE} object with all probabilities and relevant statistics inverted.
}
\description{
Inverts the predicted probabilities in an \code{ALE} object to reflect complementary outcomes (i.e., \code{1 - p}). This is particularly useful when the model probability predictions are opposite to what is desired for easy interpretability. With \code{\link[=invert_probs]{invert_probs()}}, there is no need to change the original data or retrain the model; the ALE data, p-values, and subsequent ALE plots will reflect the desired inverted probabilities.
}
\details{
This function inverts the ALE y-values (i.e., \code{.y}, \code{.y_mean}, \code{.y_median}, etc.) for all terms, including the main ALE effects, bootstrap data, and ALE statistics (\code{aler_min}, \code{aler_max}, etc.).
It also updates the \code{y_col} name and \code{y_summary} column names if \code{rename_y_col} is provided.

If the \code{ALE} object has already been inverted (\code{probs_inverted = TRUE}), the function throws an error by default.
To force reinversion (i.e., revert to original probabilities), set \code{force = TRUE}.

This operation is only permitted if the y-summary probabilities are all in the \verb{[0, 1]} interval.
}
\examples{
\donttest{
# Binary model
setosa <- iris |>
  dplyr::mutate(setosa = Species == "setosa") |>
  dplyr::select(-Species)

ale_obj <- glm(setosa ~ ., data = setosa, family = binomial()) |>
  ALE()

# Invert the predicted probabilities
ale_inverted <- invert_probs(ale_obj)

# Revert back to original by inverting again
ale_reverted <- invert_probs(ale_inverted, force = TRUE)

}

}
