# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' K-Nearest Neighbor OveRsampling approach (KNNOR)
#'
#' @param dataset `list` containing the following fields:
#'   - `embeddings`: an 2-D array (matrix) with size `batch` x `times*features`
#'   - `labels`: an 1-D array (vector) of integers with `batch` elements
#' @param k `unsigned integer` number of nearest neighbors
#' @param aug_num `unsigned integer` number of datapoints to be augmented
#' @param cycles_number_limit `unsigned integer` number of maximum try cycles
#'
#' @return Returns artificial points (`2-D array (matrix) with size `aug_num` x `times*features`)
#'
#' @references  Islam, A., Belhaouari, S. B., Rehman, A. U. & Bensmail, H. (2022).
#' KNNOR: An oversampling technique for imbalanced datasets.
#' Applied Soft Computing, 115, 108288. https://doi.org/10.1016/j.asoc.2021.108288
#'
#' @family oversampling_approaches
#'
#' @export
knnor <- function(dataset, k, aug_num, cycles_number_limit = 100L) {
    .Call(`_aifeducation_knnor`, dataset, k, aug_num, cycles_number_limit)
}

#' Validate a new point
#'
#' Function written in C++ for validating a new point (KNNOR-Validation)
#'
#' @param new_point `1-D array (vector)` new data point to be validated before adding (with `times*features` elements)
#' @param dataset `2-D array (matrix)` current embeddings (with size `batch` x `times*features`)
#' @param labels `1-D array (vector)` of integers with `batch` elements
#' @param k `unsigned integer` number of nearest neighbors
#'
#' @return Returns `TRUE` if a new point can be added, otherwise - `FALSE`
#' @family oversampling_approaches Developers
#'
#' @export
knnor_is_same_class <- function(new_point, dataset, labels, k) {
    .Call(`_aifeducation_knnor_is_same_class`, new_point, dataset, labels, k)
}

#'Reshape matrix to array
#'
#'Function written in C++ for reshaping a matrix containing sequential data into
#'an array for use with keras.
#'
#'@param matrix \code{matrix} containing the sequential data.
#'@param times \code{size_t} Number of sequences.
#'@param features \code{size_t} Number of features within each sequence.
#'@return Returns an array. The first dimension corresponds to the cases,
#'the second to the times, and the third to the features.
#'
#'@import Rcpp
#'@useDynLib aifeducation, .registration = TRUE
#'@family Utils Developers
#'@export
matrix_to_array_c <- function(matrix, times, features) {
    .Call(`_aifeducation_matrix_to_array_c`, matrix, times, features)
}

#' Transform tensor to matrix
#'
#' Function written in C++ for transformation the tensor (with size batch x times x features) to the matrix (with
#'   size batch x times*features)
#'
#' @param tensor `3-D array (cube)` data as tensor (with size batch x times x features)
#' @param times `unsigned integer` times number
#' @param features `unsigned integer` features number
#'
#' @return Returns matrix (with size batch x times*features)
#' @family Utils Developers
#' @export
tensor_to_matrix_c <- function(tensor, times, features) {
    .Call(`_aifeducation_tensor_to_matrix_c`, tensor, times, features)
}

