% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_error.R
\name{ahp.error}
\alias{ahp.error}
\title{Matrix of the product between the pairwise comparison value and pj/pi}
\usage{
ahp.error(ahpmat, atts, reciprocal = FALSE)
}
\arguments{
\item{ahpmat}{A list of pairwise comparison matrices of each decision maker generated by \code{ahp.mat}.}

\item{atts}{a list of attributes in the correct order}

\item{reciprocal}{whether to remove all numbers lower than 1 and put all numbers above 1 in the upper triangular matrix. Useful for visualizing the inconsistency rapidly.}
}
\value{
A list of matrices containing \eqn{\epsilon_{ij} = a_{ij}p_{j}/p_{i}} for each decision-maker, with elements from the lower triangle set as NA automatically (since it is essentially equal to the element in the upper triangle).
}
\description{
Consider the comparison matrix where element \eqn{a_{ij}} contains the pairwise comparison between the attributes i and j. The weights of the matrix was constructed as in \code{agg.indpref} using the Perron eigenvector where \eqn{p_{i}} and \eqn{p_{j}} are the weights of the \eqn{i^{th}} and the \eqn{j^{th}} element respectively. \code{ahp.error} constructs a matrix \eqn{\epsilon_{ij} = a_{ij}p_{j}/p_{i}}.
}
\examples{


atts <- c('cult', 'fam', 'house', 'jobs', 'trans')

data(city200)

cityahp <-  ahp.mat(city200, atts, negconvert = TRUE)
ahp.error(cityahp, atts)


}
\references{
\insertRef{Saaty2004}{ahpsurvey}
}
\author{
Frankie Cho
}
