% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_kidney.R
\name{compute_egfr}
\alias{compute_egfr}
\title{Compute Estimated Glomerular Filtration Rate (eGFR) for Kidney Function}
\usage{
compute_egfr(creat, creatu = "SI", age, weight, sex, race = NULL, method)
}
\arguments{
\item{creat}{Creatinine

A numeric vector is expected.

\describe{
\item{Default value}{none}
}}

\item{creatu}{Creatinine Units

A character vector is expected.

Expected Values: \code{"SI"}, \code{"CV"}, \code{"umol/L"}, \code{"mg/dL"}

\describe{
\item{Default value}{\code{"SI"}}
}}

\item{age}{Age (years)

A numeric vector is expected.

\describe{
\item{Default value}{none}
}}

\item{weight}{Weight (kg)

A numeric vector is expected if \code{method = "CRCL"}

\describe{
\item{Default value}{none}
}}

\item{sex}{Gender

A character vector is expected.

Expected Values: \code{"M"}, \code{"F"}

\describe{
\item{Default value}{none}
}}

\item{race}{Race

A character vector is expected if \code{method = "MDRD"}

Expected Values: \code{"BLACK OR AFRICAN AMERICAN"} and others

\describe{
\item{Default value}{\code{NULL}}
}}

\item{method}{Method

A character vector is expected.

Expected Values: \code{"CRCL"}, \code{"CKD-EPI"}, \code{"MDRD"}

\describe{
\item{Default value}{none}
}}
}
\value{
A numeric vector of egfr values
}
\description{
Compute Kidney Function Tests:
\itemize{
\item Estimated Creatinine Clearance (CRCL) by Cockcroft-Gault equation
\item Estimated Glomerular Filtration Rate (eGFR) by CKD-EPI or MDRD equations
}
}
\details{
Calculates an estimate of Glomerular Filtration Rate (eGFR)

\strong{CRCL Creatinine Clearance (Cockcroft-Gault)}

For Creatinine in umol/L:

\deqn{\frac{(140 - age) \times weight(kg) \times constant}{Serum\:Creatinine(\mu mol/L)}}

\deqn{Constant = 1.04\:for\:females, 1.23\:for\:males}

For Creatinine in mg/dL:

\deqn{\frac{(140 - age) \times weight(kg) \times (0.85\:if\:female)}{72 \times
Serum\:Creatinine(mg/dL)}}

units = mL/min

\strong{CKD-EPI Chronic Kidney Disease Epidemiology Collaboration formula}

\deqn{eGFR = 142 \times min(SCr/{\kappa}, 1)^{\alpha} \times max(SCr/{\kappa}, 1)^{-1.200}
\times 0.9938^{Age} \times 1.012 [if\:female]}

SCr = standardized serum creatinine in mg/dL
(Note SCr(mg/dL) = Creat(umol/L) / 88.42)

\deqn{\kappa} = 0.7 (females) or 0.9 (males)
\deqn{\alpha} = -0.241 (female) or -0.302 (male)
units = mL/min/1.73 m2

\strong{MDRD Modification of Diet in Renal Disease formula}

\deqn{eGFR = 175 \times (SCr)^{-1.154} \times (age)^{-0.203}
\times 0.742 [if\:female] \times 1.212 [if\:Black]}

SCr = standardized serum creatinine in mg/dL
(Note SCr(mg/dL) = Creat(umol/L) / 88.42)

units = mL/min/1.73 m2
}
\examples{
compute_egfr(
  creat = 90, creatu = "umol/L", age = 53, weight = 85, sex = "M", method = "CRCL"
)

compute_egfr(
  creat = 90, creatu = "umol/L", age = 53, sex = "M", race = "ASIAN", method = "MDRD"
)

compute_egfr(
  creat = 70, creatu = "umol/L", age = 52, sex = "F", race = "BLACK OR AFRICAN AMERICAN",
  method = "MDRD"
)

compute_egfr(
  creat = 90, creatu = "umol/L", age = 53, sex = "M", method = "CKD-EPI"
)


base <- tibble::tribble(
  ~STUDYID, ~USUBJID, ~AGE, ~SEX, ~RACE, ~WTBL, ~CREATBL, ~CREATBLU,
  "P01", "P01-1001", 55, "M", "WHITE", 90.7, 96.3, "umol/L",
  "P01", "P01-1002", 52, "F", "BLACK OR AFRICAN AMERICAN", 68.5, 70, "umol/L",
  "P01", "P01-1003", 67, "M", "BLACK OR AFRICAN AMERICAN", 85.0, 77, "umol/L",
  "P01", "P01-1004", 76, "F", "ASIAN", 60.7, 65, "umol/L",
)

base \%>\%
  dplyr::mutate(
    CRCL_CG = compute_egfr(
      creat = CREATBL, creatu = CREATBLU, age = AGE, weight = WTBL, sex = SEX,
      method = "CRCL"
    ),
    EGFR_EPI = compute_egfr(
      creat = CREATBL, creatu = CREATBLU, age = AGE, weight = WTBL, sex = SEX,
      method = "CKD-EPI"
    ),
    EGFR_MDRD = compute_egfr(
      creat = CREATBL, creatu = CREATBLU, age = AGE, weight = WTBL, sex = SEX,
      race = RACE, method = "MDRD"
    ),
  )
}
\seealso{
BDS-Findings Functions that returns a vector: 
\code{\link{compute_bmi}()},
\code{\link{compute_bsa}()},
\code{\link{compute_framingham}()},
\code{\link{compute_map}()},
\code{\link{compute_qtc}()},
\code{\link{compute_qual_imputation}()},
\code{\link{compute_qual_imputation_dec}()},
\code{\link{compute_rr}()},
\code{\link{compute_scale}()},
\code{\link{transform_range}()}
}
\concept{com_bds_findings}
\keyword{com_bds_findings}
