% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbFetch_AdbiResult.R
\name{dbFetch_AdbiResult}
\alias{dbFetch_AdbiResult}
\alias{dbFetch,AdbiResult-method}
\title{Fetch result sets}
\usage{
\S4method{dbFetch}{AdbiResult}(res, n = -1, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}, created by
\code{\link[DBI:dbSendQuery]{dbSendQuery()}}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{...}{Other arguments passed on to methods.}
}
\value{
A \code{data.frame} with the requested number of rows (or zero rows if
\code{\link[=dbFetch]{dbFetch()}} is called on a result set with no more remaining rows).
}
\description{
When fetching results using \code{\link[=dbFetch]{dbFetch()}}, the argument \code{n} can be specified
to control chunk size per fetching operation. The default value of \code{-1}
corresponds to retrieving the entire result set at once, while a positive
integer will try returning as many rows (as long as \code{n} does not exceed the
available number of rows), in line with standard DBI expectations. As data
transfer is mediated by Arrow data structures, which are retrieved as array
chunks, the underlying chunk size can be used by passing an \code{n} value \code{NA}.
}
\examples{
if (requireNamespace("adbcsqlite")) {
  library(DBI)
  con <- dbConnect(adbi::adbi("adbcsqlite"), uri = ":memory:")
  dbWriteTable(con, "swiss", swiss)
  res <- dbSendQuery(con, "SELECT * from swiss WHERE Agriculture < 30")
  dbFetch(res)
  dbClearResult(res)
  dbDisconnect(con)
}
}
