% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{BalanceProperty}
\alias{BalanceProperty}
\title{Balance property}
\usage{
BalanceProperty(obj)
}
\arguments{
\item{obj}{an object containing the model fit}
}
\value{
a list with the slots \code{call} (the original call), \code{BalanceProperty} (logical indicating whether the balance
property is satisfied) and \code{Alpha} (Ratio total observed damage to total predicted damage).
}
\description{
Function to assess whether the balance property holds
}
\examples{
\donttest{
fit = hierCredGLM(Y ~ area + (1 | VehicleType / VehicleBody), dataCar, weights = w,
 p = 1.75, epsilon = 1e-6)
BalanceProperty(fit)
}
}
\references{
Campo, B.D.C. and Antonio, Katrien (2023). Insurance pricing with hierarchically structured data an illustration with a workers' compensation insurance portfolio. \emph{Scandinavian Actuarial Journal}, doi: 10.1080/03461238.2022.2161413

Wüthrich, M. V. (2020). Bias regularization in neural network models for general insurance pricing. \emph{European actuarial journal} \bold{10}(1), 179–202.
}
