% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiers_rename.R
\name{tiers_rename}
\alias{tiers_rename}
\title{Rename tiers}
\usage{
tiers_rename(x, searchPattern, searchReplacement, filterTranscriptNames = NULL)
}
\arguments{
\item{x}{Corpus object.}

\item{searchPattern}{Character string; search pattern as regular expression.}

\item{searchReplacement}{Character string; replacement string.}

\item{filterTranscriptNames}{Vector of character strings; names of the transcripts to be included.}
}
\value{
Corpus object.
}
\description{
Renames all tiers in all transcript objects of a corpus.
If only certain transcripts should be affected set the parameter \code{filterTranscriptNames}.
In case that you want to select transcripts by using regular expressions use the function \code{act::search_makefilter} first.
}
\details{
The tiers will only be renamed if the resulting names preserve the uniqueness of the tier names.
Results  will be reported in \code{@history} of the transcript objects.
Please be aware that this function is not optimized for speed and may take quite a while to run, depending on the size of your corpus object.
}
\examples{
library(act)

# Check the names of the existing tiers in the first two transcripts
examplecorpus@transcripts[[1]]@tiers$name
examplecorpus@transcripts[[2]]@tiers$name

x <- act::tiers_rename(examplecorpus, "Entrevistador", "E")

x@transcripts[[1]]@tiers$name
x@transcripts[[2]]@tiers$name

}
\seealso{
\link{tiers_add}, \link{tiers_convert}, \link{tiers_rename}, \link{tiers_sort}, \link{helper_tiers_new_table}, \link{helper_tiers_sort_table}
}
