% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations_replace_copy.R
\name{annotations_replace_copy}
\alias{annotations_replace_copy}
\title{Search, replace and copy the contents of annotations}
\usage{
annotations_replace_copy(
  x,
  pattern,
  replacement = NULL,
  destTier = NULL,
  addDestTierIfMissing = TRUE,
  filterTranscriptNames = NULL,
  filterTierNames = NULL,
  collapseString = " | "
)
}
\arguments{
\item{x}{Corpus object.}

\item{pattern}{Character string; search pattern as regular expression.}

\item{replacement}{Character string; replacement.}

\item{destTier}{Character string; name of the tier to which the hit should be copied (if no copying is intended set to NA).}

\item{addDestTierIfMissing}{Logical; if \code{TRUE} the destination tier will be added if missing in the transcript object, if \code{FALSE} an error will be raised if the destination tier is missing.}

\item{filterTranscriptNames}{Vector of character strings; names of the transcripts to be included.}

\item{filterTierNames}{Character string; names of the tiers to be included.}

\item{collapseString}{Character string; will be used to collapse multiple search results into one string.}
}
\value{
Corpus object.
}
\description{
The function searches within the contents of annotations and replaces the search hits.
In addition the search hit may be copied to another tier.
In case that there is NO overlapping annotation in the destination tier a new annotation will be created (based on the time values of the original annotation).
In case that there is an overlapping annotation in the destination tier, the search result will be added at the end.
}
\details{
If only certain transcripts or tiers should be affected set the parameter \code{filterTranscriptNames} and \code{filterTierNames}.
In case that you want to select transcripts and/or tiers by using regular expressions use the function \code{act::search_makefilter} first.
}
\examples{
library(act)

# Have a look at the first transcript in the examplecorpus:
printtranscript <- act::export_printtranscript(examplecorpus@transcripts[[1]])
cat(printtranscript)
# In line 01 there is the word "UN".

# Replace this word by "XXX" in the entire corpus
test <- act::annotations_replace_copy(x=examplecorpus,
									  pattern="\\\\bUN\\\\b",
									  replacement="XXX")

# Have a look at the first transcript in the corprus object test:
printtranscript <- act::export_printtranscript(test@transcripts[[1]])
cat(printtranscript)
# In line 01 there is now "XXX" instead of "UN"

# Insert a tier called "newTier" into all transcripts in the corpus:
for (t in examplecorpus@transcripts) {
	sortVector <- c(t@tiers$name, "newTier")
	examplecorpus <- act::tiers_sort(x=examplecorpus,
	sortVector=sortVector,
	filterTranscriptNames=t@name,
	addMissingTiers=TRUE)
}
# Check that the first transcript now contains the newTier
examplecorpus@transcripts[[1]]@tiers

# Now replace "UN" by "YYY" in the entire corpus and
# copy the search hit to "newTier".
test <- act::annotations_replace_copy(x=examplecorpus,
									  pattern="\\\\bUN\\\\b",
									  replacement="YYY",
									  destTier = "newTier")

# Have a look again at the first transcript in the corpus object test.
printtranscript <- act::export_printtranscript(test@transcripts[[1]])
cat(printtranscript)
# In line 01 you see that "UN" has been replaced by "YYY.
# In line 02 you see that it has been copied to the tier "newTier".

# If you only want to copy a search hit but not replace it in the original
# leave replacement="", which is the default
test <- act::annotations_replace_copy(x=examplecorpus,
									  pattern="\\\\bUN\\\\b",
									  destTier = "newTier")
printtranscript <- act::export_printtranscript(test@transcripts[[1]])
cat(printtranscript)
# In line 01 you see that "UN" has been maintained.
# In line 02 you see that "UN" it has been copied to the tier "newTier".
}
