% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_eaf.R
\name{import_eaf}
\alias{import_eaf}
\title{Import a single 'ELAN' '*.eaf' file}
\usage{
import_eaf(filePath = NULL, fileContent = NULL, transcriptName = NULL)
}
\arguments{
\item{filePath}{Character string; input path of a single 'ELAN' .eaf file.}

\item{fileContent}{Vector of character strings; contents of an 'ELAN' .eaf file read by \code{readLines()}.}

\item{transcriptName}{Character string; name of the transcript.}
}
\value{
Transcript object.
}
\description{
Advice: In most situations it is more convenient to use \code{act::corpus_new}, \code{act::corpus_import} for importing annotation files.
 
Imports the contents of a 'ELAN' .eaf file and returns a transcript object.
The input to this function is either the path to an .eaf file or the contents of a .eaf file obtained from the \code{@file.content} of an existing transcript object by \code{readLines()}.
If you pass 'fileContent' you need to pass 'transcriptName' as parameter, too.
}
\details{
Please note:
- 'ELAN' offers a variety of tier types, some including dependencies from other tiers. Therefore not all annotations do actually have a time value. Missing values will be detected in the superordinate tier or will be interpolated. You will not be able to recognize interpolated values in the annotations.  
- Please also note that dependencies between tiers in you .eaf file are not reflected in the transcript object within the act package.
}
\examples{
library(act)

# Path to an .eaf file that you want to read
path <- system.file("extdata", "examplecorpus", "SYNC", 
					"SYNC_rotar_y_flexionar.eaf", package="act")


# To import a .eaf file of your choice:
\dontrun{
path <- "PATH_TO_AN_EXISTING_EAF_ON_YOUR_COMPUTER"
}


t <- act::import_eaf(filePath=path)
t

# Content of an .eaf file (already read by \code{readLines}), 
# e.g. from an existing transcript object:
mycontent <- examplecorpus@transcripts[['SYNC_rotar_y_flexionar']]@file.content
t <- act::import_eaf(fileContent=mycontent, transcriptName="test")
t

}
\seealso{
\code{corpus_import}, \code{corpus_new}, \code{import}, \code{import_exb}, \code{import_rpraat}, \code{import_textgrid}
}
