% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_format_time.R
\name{helper_format_time}
\alias{helper_format_time}
\title{Formats time as HH:MM:SS,mmm}
\usage{
helper_format_time(
  t,
  digits = 0,
  addHrsMinSec = FALSE,
  addTimeInSeconds = FALSE
)
}
\arguments{
\item{t}{Double; time in seconds.}

\item{digits}{Integer; number of digits.}

\item{addHrsMinSec}{Logical; if \code{TRUE} 'hrs' 'min' 'sec' will be used instead of ':'.}

\item{addTimeInSeconds}{Logical; if \code{TRUE} time value in seconds will be shown, too.}
}
\value{
Character string.
}
\description{
Formats time as HH:MM:SS,mmm
}
\examples{
library(act)


helper_format_time(12734.2322345)
helper_format_time(2734.2322345)
helper_format_time(34.2322345)
helper_format_time(0.2322345)

helper_format_time(12734.2322345, addHrsMinSec=TRUE)
helper_format_time(2734.2322345, addHrsMinSec=TRUE)
helper_format_time(34.2322345, addHrsMinSec=TRUE)
helper_format_time(0.2322345, addHrsMinSec=TRUE)

helper_format_time(12734.2322345, digits=3)
helper_format_time(2734.2322345, digits=3)
helper_format_time(34.2322345, digits=3)
helper_format_time(0.2322345, digits=3)

helper_format_time(12734.2322345, addHrsMinSec=TRUE, digits=3)
helper_format_time(2734.2322345, addHrsMinSec=TRUE, digits=3)
helper_format_time(34.2322345, addHrsMinSec=TRUE, digits=3)
helper_format_time(0.2322345, addHrsMinSec=TRUE, digits=3)

helper_format_time(12734.2322345, addHrsMinSec=TRUE, addTimeInSeconds=TRUE)
helper_format_time(2734.2322345, addHrsMinSec=TRUE, addTimeInSeconds=TRUE)
helper_format_time(34.2322345, addHrsMinSec=TRUE, addTimeInSeconds=TRUE)
helper_format_time(0.2322345, addHrsMinSec=TRUE, addTimeInSeconds=TRUE)

helper_format_time(12734.2322345, addHrsMinSec=TRUE, digits=3, addTimeInSeconds=TRUE)
helper_format_time(2734.2322345, addHrsMinSec=TRUE, digits=3, addTimeInSeconds=TRUE)
helper_format_time(34.2322345, addHrsMinSec=TRUE, digits=3, addTimeInSeconds=TRUE)
helper_format_time(0.2322345, addHrsMinSec=TRUE, digits=3, addTimeInSeconds=TRUE)

}
