#' @name acled_access
#' @title Store your ACLED access information into your session.
#' `r lifecycle::badge("deprecated")`
#'
#' @description Simple function to authenticate and store (through `Sys.setenv()`) ACLED access key for the acled_api() function. If email and key is stored via acled_access, the email and key arguments for acled_api can be NULL.
#'
#' This function is deprecated and will stop functioning in September 2025. Please use your ACLED email and password to authenticate your requests in the acled_api() and associated functions which manage ACLED OAuth tokens for you.
#' @param email This is the email that you register in the ACLED Access portal (https://developer.acleddata.com/)
#' @param key This is the key generated by the ACLED Access portal.
#' @family API and Access
#' @returns Returns a success message if ACLED credentials are successfully authorized
#' @examples
#' \dontrun{
#' acled_access(email = "your_email", key = "your_key")
#' Sys.getenv("acled_email")
#' Sys.getenv("acled_key")
#' }
#' @export
#' @md


acled_access <- function(email, key) {
  url <- paste0("https://api.acleddata.com/check/read/?email=", email, "&", "key=", key)


  response <- httr::GET(url)
  out <- httr::content(response)

  if (out$status != 200) {
    if ((out$error$message) == "Incorrect email or access key entered. Please try again.") {
      stop(paste0(
        "Error: ", out$error$message, ". Error code: ", out$status, ". \n",
        rlang::format_error_bullets(c(
          "Key and email not authorized. Please verify your API credentials (key and email) and try again",
          "If the error persists please contact access@acleddata.com."
        ))
      ))
    } else {
      stop(paste0("Error: ", out$error$message, ". Error code: ", out$status))
    }
  } else {
    if (out$status == 200) {
      message("Success! Credentials authorized")
    }

    Sys.setenv(acled_email = email)
    Sys.setenv(acled_key = key)
  }
}
