% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APG_EN2.R
\name{APG_EN2}
\alias{APG_EN2}
\title{Accelerated Proximal Gradient on l1 regularized quadratic program}
\usage{
APG_EN2(A, d, x0, lam, alpha, maxits, tol, selector = rep(1, dim(x0)[1]))
}
\arguments{
\item{A}{p by p positive definite coefficient matrix
\deqn{A = (\gamma Om + X^T X/n)}{A = (gamma Om + X^T X/n)}.}

\item{d}{nx1 dimensional column vector.}

\item{lam}{Regularization parameter for l1 penalty, must be greater than zero.}

\item{alpha}{Step length.}

\item{maxits}{Number of iterations to run}

\item{tol}{Stopping tolerance for proximal gradient algorithm.}

\item{selector}{Vector to choose which parameters in the discriminant vector will be used to calculate the
regularization terms. The size of the vector must be *p* the number of predictors. The
default value is a vector of all ones. This is currently only used for ordinal classification.}
}
\value{
\code{APG_EN2} returns an object of \code{\link{class}} "\code{APG_EN2}" including a list
with the following named components

\describe{
  \item{\code{call}}{The matched call.}
  \item{\code{x}}{Found solution.}
  \item{\code{k}}{Number of iterations used.}
}
}
\description{
Applies accelerated proximal gradient algorithm to the l1-regularized quadratic program
\deqn{f(\mathbf{x}) + g(\mathbf{x}) = \frac{1}{2}\mathbf{x}^TA\mathbf{x} - d^T\mathbf{x} + \lambda |\mathbf{x}|_1}{f(x) + g(x) = 0.5*x^T*A*x - d^T*x + lambda*|x|_l1}
}
\details{
This function is used by other functions and should only be called explicitly for
debugging purposes.
}
\seealso{
Used by: \code{\link{SDAAP}} and the \code{SDAAPcv} cross-validation version.
}
\keyword{internal}
