% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateabn.R
\name{makebugsGroup}
\alias{makebugsGroup}
\title{Make BUGS model from fitted DAG with grouping}
\usage{
makebugsGroup(
  dag,
  data.dists,
  stderrors,
  group.var,
  mu,
  betas,
  sigma,
  sigma_alpha
)
}
\arguments{
\item{dag}{named adjacency matrix representing the DAG. Names correspond to node names.}

\item{data.dists}{list of node distributions.}

\item{stderrors}{a list named by the node names containing for each element a matrix with the nodes' standard errors}

\item{group.var}{only applicable for mixed models and gives the column name in \code{data.df} of the grouping variable (which must be a factor denoting group membership).}

\item{mu}{Standard deviation of fixed effects.}

\item{betas}{Coefficients/slopes of fixed effects .}

\item{sigma}{variance of random effects.}

\item{sigma_alpha}{variance-covariance matrix corresponding to covariances output from \code{\link[mclogit]{mblogit}}.}
}
\value{
Bugs model returned as stdout.
}
\description{
Make BUGS model from fitted DAG with grouping
}
\seealso{
\link{simulateAbn} \link{gauss_bugsGroup} \link{bern_bugsGroup} \link{categorical_bugsGroup} \link{pois_bugsGroup}
}
\keyword{internal}
\keyword{utilities}
