% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_hist.R
\name{smooth_hist}
\alias{smooth_hist}
\title{Histogram smoothing for whitestripe}
\usage{
smooth_hist(
  x,
  y,
  deg = 4,
  k = floor(min(250, length(x)/2)),
  method = "REML",
  ...
)
}
\arguments{
\item{x}{values of midpoints from \code{\link{hist}}}

\item{y}{values of counts from \code{\link{hist}}}

\item{deg}{degree of polynomials used}

\item{k}{Number of knots}

\item{method}{Method for smoothing for GAM}

\item{...}{Arguments passed to \code{\link{gam}}}
}
\value{
List of objects: x and y coordinates of histogram, coefficients from GAM, 
fitted values from GAM, the GAM model, the knots fitted, and degrees of polynomials
}
\description{
Uses a generalized additive model (GAM) to smooth a 
histogram for whitestripe
}
\examples{
data(t2.voi.hist)
y = t2.voi.hist$counts
x = t2.voi.hist$mids
x = x[!is.na(y)];
y = y[!is.na(y)]
# 30 used for speed of example
s.hist = smooth_hist(x, y, k=30)
plot(t2.voi.hist, border="red")
lines(s.hist)
}
\seealso{
\link[mgcv]{gam}
}
