\name{workingDirectoryPopulate}
\alias{workingDirectoryPopulate}
\title{Create  files in the working directory to be used for report generation
}
\description{
The function creates the specified directory (if it does not already exist) and creates the configured file directory (by default the name is 'txdata') if that does not exist.  If the files directory has an absolute path it is created, if it is a relative path it is appended to the work directory path and created.  The work directory contains the report template and scripts, the files directory holds the images that are generated by the report template.  
It creates the following files:
\describe{
\item{makerpt.ps1}{PowerShell script to generate the report.  The script is run by specifying its name followed by the stem part of the R file that contains the script \code{.\\makerpt.ps1 reportname}}
\item{makerpt.sh}{bash script to generate the report.  The script is run by specifying its name followed by the stem part of the R file that contains the script \code{./makerpt.sh reportname}}
\item{size10.clo}{A file used by LaTex that specifies the page layout}
\item{webanalyticsreport.cls}{A latex document class that the report uses}
\item{logo.eps}{A 2cm square eps logo placed in the top right corner of each report page}
\item{sampleRfile.R}{An outline R report file}
}
If a file exists and has different content to the new file it will be renamed (a timestamp suffix added to the name) before the new file is created.
}
\usage{
workingDirectoryPopulate(directoryName = ".")
}
\arguments{
  \item{directoryName}{
A character string that specifies the name of the directory to be created and populated
}
}
\value{
The function does not return a value}
\author{
Greg Hunt <greg@firmansyah.com>
}

\examples{
# in the current directory run it as 
# workingDirectoryPopulate()
\dontshow{
# make some directory names
filesDirName = paste0(tempdir(),"/txd")
configVariableSet("config.workdir", filesDirName)
}

workingDir = paste0(tempdir(),"/wk")

workingDirectoryPopulate(workingDir)

\dontshow{
# remove the created example directories
unlink(filesDirName,recursive=TRUE)
unlink(workingDir,recursive=TRUE)
}
}
\keyword{ utilities }
