% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wass_regress.R
\name{wass_regress}
\alias{wass_regress}
\title{Perform Frechet Regression with the Wasserstein Distance}
\usage{
wass_regress(rightside_formula, Xfit_df, Ytype, Ymat, Sup = NULL)
}
\arguments{
\item{rightside_formula}{a right-side formula}

\item{Xfit_df}{n-by-p matrix (or dataframe) of predictor values for fitting (do not include a column for the intercept)}

\item{Ytype}{'quantile' or 'density'}

\item{Ymat}{one of the following matrices:
\itemize{
\item{if Ytype = 'quantile'} Ymat is an n-by-m matrix of the observed quantile functions. Ymat[i, :] is a 1-by-m vector of quantile function values on grid \code{Sup}.
\item{if Ytype = 'density'} Ymat is an n-by-m matrix of the observed density functions. Ymat[i, :] is a 1-by-m vector of density function values on grid \code{Sup}.
}}

\item{Sup}{one of the following vectors:
\itemize{
\item{if Ytype = 'quantile'} Sup is a length m vector - common grid for all quantile functions in Ymat (default: seq(0, 1, length.out = ncol(Ymat))).
\item{if Ytype = 'density'} Sup is a length m vector - common grid for all density functions in Ymat (default: seq(0, 1, length.out = ncol(Ymat))).
}}
}
\value{
a list containing the following objects:
\item{call}{function call}
\item{rformula}{\code{rightside_formula}}
\item{predictor_names}{names of predictors as the colnames given in the xfit matrix or dataframe.}
\item{Qfit}{n-by-m matrix of fitted quantile functions.}
\item{xfit}{design matrix in quantile fitting.}
\item{Xfit_df}{n-by-p matrix (or dataframe) of predictor values for fitting}
\item{Yobs}{a list containing the following matrices:
\itemize{
\item{Qobs:} {n-by-m matrix of the observed quantile functions.}
\item{qobs:} {n-by-m matrix of the observed quantile density functions.}
\item{qobs_prime:} {n-by-m matrix of the first derivative of the observed quantile density functions.}
\item{fobs:} {n-by-m matrix of the observed density functions.}
}}
\item{t_vec}{a length m vector - common grid for all quantile functions in Qobs.}
}
\description{
Perform Frechet Regression with the Wasserstein Distance
}
\examples{
data(strokeCTdensity)
predictor = strokeCTdensity$predictors
dSup = strokeCTdensity$densitySupport
densityCurves = strokeCTdensity$densityCurve

res1 = wass_regress(rightside_formula = ~., Xfit_df = predictor,
 Ytype = 'density', Ymat = densityCurves, Sup = dSup)
res2 = wass_regress(rightside_formula = ~ log_b_vol * weight, Xfit_df = predictor,
 Ytype = 'density', Ymat = densityCurves, Sup = dSup)
}
\references{
\cite{Wasserstein F-tests and confidence bands for the Frechet regression of density response curves, Alexander Petersen, Xi Liu and Afshin A. Divani, 2019}
}
