% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetData.R
\name{GetDataSEPA_QH}
\alias{GetDataSEPA_QH}
\title{Get flow or level data from the Scottish Environmental Protection Agency.}
\usage{
GetDataSEPA_QH(
  Lat = NULL,
  Lon = NULL,
  RiverName = NULL,
  Type = "Flow",
  StationID = NULL,
  Range = 20,
  From = NULL,
  To = NULL,
  Period = "Daily"
)
}
\arguments{
\item{Lat}{Latitude (as a decimal) for the centre of the search for gauges. You can convert BNG to Lat and Lon using the GridRefConvert function.}

\item{Lon}{Longitude (as a decimal) for the centre of the search for gauges. You can convert BNG to Lat and Lon using the GridRefConvert function.}

\item{RiverName}{Name of the river along which you want to search for gauges. Character string.}

\item{Type}{The variable to extract, either "flow" or "level"}

\item{StationID}{The ID for the gauge from which you want to obtain data (character string)}

\item{Range}{Radius of search when using latitude and longitude inputs (km).}

\item{From}{Date for start of data extraction in the format of "2015-12-02". If NULL the first date of the available data is used.}

\item{To}{Date for the end of data extraction in the format of "2015-12-02". If NULL the present date is used (and most recent available data is returned).}

\item{Period}{The sampling rate of the data you want. Either "Daily", "Hourly", or "15Mins".}
}
\value{
If searching for gauge details with lat and lon or river name, then a dataframe is returned with necessary information to obtain flow or level data.
When extracting flow or level data with a station ID then a dataframe with two columns is returned. The first being a Date or POSIXct column/vector and the second is the timeseries of interest.
}
\description{
Function to extract flow or level data from SEPA.
}
\details{
To find gauges you can input either a river name or a latitude and longitude. You can convert BNG to Lat and Lon using the ConvertGridRef function. The lat and lon option will provide all flow or level gauges within a specified range (default of 50km). This provides gauged details including the StationID. You can get data from specific gauges using the StationID. Note that flow gauges also have level data available. You can get data from a date range using the From and To arguments. If the From and To arguments are left as NULL the full range of available data are returned.
}
\examples{
#Find gauges on the river Spey
\dontrun{GetDataSEPA_QH(RiverName = "Spey")}
#Find gauges within 20km of a latlon grid reference somewhere near the centre of Scotland
\dontrun{GetDataSEPA_QH(lat = 56, lon = -4, Range = 20)}
#Get all available daily mean flow data from the Boat o Brig gauge on the Spey
\dontrun{SpeyDaily <- GetDataSEPA_QH(StationID = "37174")}
#Get 15-minute data from the Boat o Brig for the highest recorded peak
\dontrun{BoatOBrigAug1970 <- GetDataSEPA_QH(StationID = "37174",
From = "1970-08-16", To = "1970-08-19", Period = "15Mins")}
}
\author{
Anthony Hammond
}
