% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_lda.R
\name{lda_distribution}
\alias{lda_distribution}
\title{View distribution of fitted LDA Models}
\usage{
lda_distribution(lda_model, param = "gamma", tidy = FALSE)
}
\arguments{
\item{lda_model}{Object of class \link[topicmodels:TopicModel-class]{LDA}).}

\item{param}{String. Specify either "beta" to return the term distribution
over topics (term per document) or "gamma" for the document distribution over.
 topics (i.e. hashtag pool per topic probability).}

\item{tidy}{Logical. Specify \code{TRUE} for return distribution in tidy format (tbl).}
}
\value{
Data frame or tbl of Term (beta) or document (gamma) distribution over topics.
}
\description{
View the distribution of your fitted LDA model.
}
\examples{
\dontrun{

library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

# Pool tweets into longer pseudo-documents
pool <- pool_tweets(data = mytweets)
pooled_dfm <- pool$document_term_matrix

# fit your LDA model with 7 topics
model <- fit_lda(pooled_dfm, n_topics = 7, method = "Gibbs")

# Choose either "beta" to return the term distribution
# over topics (term per document) or "gamma" for the document distribution over
# topics (hashtag pool per topic probability)
lda_distribution(model, param = "gamma")
}
}
