% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_lda.R
\name{fit_lda}
\alias{fit_lda}
\title{Fit LDA Topic Model}
\usage{
fit_lda(pooled_dfm, n_topics, ...)
}
\arguments{
\item{pooled_dfm}{Object of class dfm (see \link[quanteda]{dfm}) containing (pooled) tweets.}

\item{n_topics}{Integer with number of topics.}

\item{...}{Additional arguments passed to \link[topicmodels]{LDA}.}
}
\value{
Object of class \link[topicmodels:TopicModel-class]{LDA}.
}
\description{
Estimate a LDA topic model using VEM or Gibbs Sampling.
}
\examples{
\dontrun{

library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

# Pool tweets into longer pseudo-documents
pool <- pool_tweets(data = mytweets)
pooled_dfm <- pool$document_term_matrix

# fit your LDA model with 7 topics
model <- fit_lda(pooled_dfm, n_topics = 7, method = "Gibbs")
}
}
