% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tLUfft.R
\name{tLUfft}
\alias{tLUfft}
\title{LU decomposition of a 3D tensor using the discrete fast fourier transform}
\usage{
tLUfft(tnsr)
}
\arguments{
\item{tnsr, }{a 3-mode S3 tensor class object}
}
\value{
L, The lower triangular S3 tensor object

U, The upper triangular S3 tensor object
}
\description{
LU decomposition of a 3D tensor using the discrete fast fourier transform
}
\examples{
T <- t_rand(modes=c(2,2,4))
tLUfft(T)
}
\references{
M. E. Kilmer, C. D. Martin, and L. Perrone, “A third-order generalization of the matrix svd as a product of third-order tensors,” Tufts University, Department of Computer Science, Tech. Rep. TR-2008-4, 2008

K. Braman, "Third-order tensors as linear operators on a space of matrices", Linear Algebra and its Applications, vol. 433, no. 7, pp. 1241-1253, 2010.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
