% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParSort.r
\docType{class}
\name{parSort-class}
\alias{parSort-class}
\alias{[,parSort,ANY,ANY,ANY-method}
\alias{[,parSort-method}
\title{An S4 class to represent the parameters for tree assorting.}
\usage{
\S4method{[}{parSort,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{object from which to extract}

\item{i}{index i}

\item{j}{index j}

\item{...}{not currently used}

\item{drop}{drop dimensions, defaults to FALSE}
}
\value{
a part of the original object
}
\description{
This class represents one or multiple parameter sets holding the
necessary information to specify the assortment process.

using indices i and j to subset
}
\details{
The assortment process is defined by several parameters. These
follow the specification of its ancestor BDAT , but
are extended to allow for fix length assortments at the tree top
(industrial wood / pulp wood) and relaxes transport length and stump height.
\itemize{
  \item stH: stump height, defaults to 0, i.e. 1\% of tree height
  \item Lxh: length of unusable wood at stem foot [m], defaults to 0 (X-Holz)
  \item Hkz: indicator for tree top, 0 - normal, 1 - Wipfelbruch,
  2 - Gipfelbruch
  \itemize{
    \item 0 => H=H (default)
    \item 1 => H=H+2
    \item 2 => DBH < 30 => H=DBH; dbh > 30 => H = 30 + (DBH-30) * 0.3
  }
  \item Skz: indicator for stem type, defaults to 0
  \itemize{
    \item 0 => conifer trees => no assortment restriction;
    deciduous trees => no assortments
    \item 1 => monopodial deciduous trees => Hsh = 0.7*H
    \item 2 => branching between dbh and 7m => Hsh = 5m
    \item 3 => crown base < 3m => Hsh=0.1
    \item 4 => dead or broken stem => Az = H*0.7
    \item 5 => dead tree => non-usable wood
  }
  \item Hsh: usable stem height, defaults to 0, i.e. 0.7*H
  \item Zsh: minimum cutting diameter under bark for stem wood [cm], defaults
  to 0, using parameter \code{Az} if estimated length < maximum length
  (i.e. 20m)
  \item Lsh: length of stem wood, defaults to 0, i.e. length unrestricted
  \item Zab: minimum cutting diameter under bark for top segment [cm],
  defaults to 0, i.e. 14cm under bark
  \item Lab: length of top segment, defaults to 0, i.e. length unrestricted
  \item Az: minimum cutting diameter over bark [cm], defaults to 0,
  using an exponential function given DBH to estimate Az
  \item LIh: length of industrial wood [m], defaults to 0, i.e. length
  unrestricted
  \item trL: maximum transport length of assortments, defaults to 0, i.e. 19m
  \item fixN: number of fixed length assortments at stem foot, defaults to 0
  (no fixed length assortments, irrespective of other fix* parameters)
  \item fixZ: mininum diameter under bark for fixed length assortment at
  stem foot, defaults to 0
  \item fixL: length of fixed length assortment at stem foot, defaults to 0
  \item fixA: fixed length assortement add-on in [cm], defaults to 0
  \item fixR: fixed length assortement add-on in [\%], defaults to 0
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{x[i}: subsetting for class 'parSort'

}}
\section{Slots}{

\describe{
\item{\code{stH}}{stump height}

\item{\code{Lxh}}{length of unusable wood at stem foot, see details}

\item{\code{Hkz}}{height indicator, see details}

\item{\code{Skz}}{stem indicator, see details}

\item{\code{Hsh}}{height of stem wood, see details}

\item{\code{Zsh}}{cutting diameter of stem wood, see details}

\item{\code{Lsh}}{length of stem wood, see details}

\item{\code{Zab}}{cutting diameter of upper trunk, see details}

\item{\code{Lab}}{length of upper trunk, see details}

\item{\code{Az}}{minimal cutting diameter, defaults to 7cm, see details}

\item{\code{LIh}}{length of industrial wood, see details}

\item{\code{trL}}{maximum transport length}

\item{\code{fixN}}{number of fixed length assortments, see details}

\item{\code{fixL}}{length of fixed length assortments, see details}

\item{\code{fixZ}}{cutting diameter of fixed length assortments, see details}

\item{\code{fixA}}{absolute add-on for good measure of fixed length assortments,
see details}

\item{\code{fixR}}{relative add-on for good measure of fixed length assortments,
see details}
}}

\examples{
parSort()
parSort(Lxh=1)
parSort(n=2)
}
\keyword{methods}
