% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{azp}
\alias{azp}
\title{Data: Function Parameters to estimate cutting diameter}
\format{
A two-dimensional array. rows refer to species, columns to parameter
of linear model.
}
\source{
BDAT-Fortran-library
}
\usage{
azp
}
\description{
Parameters for linear regression model of form
Az=exp(p1+p2*log(dbh)+p3*(log(dbh)^2)+p4*dbh).
Function returns expected cutting diameter according to species and diameter
in breast height (dbh). Parameters taken from source code of BDAT.
}
\details{
The implemented species are (column=species name):
1=Norway spruce (S-Dt)
2=Norway spruce (N-Dt)
3=Silver fir
4=Scots pine
5=European larch
6=European beech
7=Quercus petraea and robur, possibly rubra
}
\examples{
data(azp)
dim(azp)
azp[1,] # 1=Norway spruce (S-Dt)
dbh <- 30
exp(azp[1,1]+azp[1,2]*log(dbh)+azp[1,3]*(log(dbh)^2)+azp[1,4]*dbh) # as implemented

}
\references{
Kublin and Scharnagl, 1988.
}
\keyword{datasets}
