% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_interactions.R
\name{create_interactions}
\alias{create_interactions}
\title{Interactions as Violation Space Candidates}
\usage{
create_interactions(Z, X = NULL)
}
\arguments{
\item{Z}{observations of the instrumental variable(s). Either a numeric vector of length n
or a numeric matrix with dimension n by s.}

\item{X}{observations of baseline covariate(s) for which interactions with the instrumental variable(s) should
be part of the violation space candidates. Either a numeric vector of length n
or a numeric matrix with dimension n by p or \code{NULL}
(if only interactions between the instrumental variales itself should be part
of the violation space candidates).}
}
\value{
A ordered list. The first element contains the observations of the
instrumental variable(s) \code{Z}. The second element contains all interactions between
the instrumental variable(s) and the baseline covariate(s) \code{X}.
}
\description{
Interactions as Violation Space Candidates
}
\examples{
Z <- matrix(rnorm(100 * 3), nrow = 100, ncol = 3)
X <- matrix(rnorm(100 * 3), nrow = 100, ncol = 3)
vio_space <- create_interactions(Z = Z, X = X)
}
