% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_cor.R
\name{compare_cor}
\alias{compare_cor}
\title{Comparing two independent correlation coefficients}
\usage{
compare_cor(
  r1,
  df1,
  r2,
  df2,
  method = c("fisher", "kraatz"),
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  null = 0
)
}
\arguments{
\item{r1}{Correlation study 1.}

\item{df1}{Degrees of freedom from study 1 (if a simple correlation the df is N-2).}

\item{r2}{Correlation study 2.}

\item{df2}{Degrees of freedom from study 2 (if a simple correlation the df is N-2).}

\item{method}{Method for determining differences. Default, "z", will use Fisher's transformation, while "Kraatz" will use the Kraatz method.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater", "less", "equivalence" (TOST), or "minimal.effect" (TOST). You can specify just the initial letter.}

\item{null}{a number indicating the null hypothesis. For TOST, this would be equivalence bound.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function to compare correlations between studies. This function is intended to be used to compare the compatibility of original studies with replication studies (lower p-values indicating lower compatibility).
}
\details{
This function tests for differences between correlations.
@return A list with class "htest" containing the following components:
\itemize{
\item "statistic":  z-score
\item "p.value":  numeric scalar containing the p-value for the test under the null hypothesis.
\item "estimate":  difference in SMD between studies.
\item "null.value":  the specified hypothesized value for the null hypothesis.
\item "alternative":  character string indicating the alternative hypothesis (the value of the input argument alternative). Possible values are "greater", "less", or "two-sided".
\item "method":  Type of SMD.
\item "data.name":  "Summary Statistics" to denote summary statistics were utilized to obtain results.
\item "cor":  Correlation input for the function.
\item "call":  the matched call.
}
}
\references{
Counsell, A., & Cribbie, R. A. (2015). Equivalence tests for comparing correlation and regression coefficients. The British journal of mathematical and statistical psychology, 68(2), 292–309. https://doi.org/10.1111/bmsp.12045

Anderson, S., & Hauck, W. W. (1983). A new procedure for testing equivalence in comparative bioavailability and other clinical trials. Communications in Statistics-Theory and Methods, 12(23), 2663-2692.
}
\seealso{
Other compare studies: 
\code{\link{boot_compare_cor}()},
\code{\link{boot_compare_smd}()},
\code{\link{compare_smd}()}
}
\concept{compare studies}
