% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTP_TMTI.R
\name{CTP_TMTI}
\alias{CTP_TMTI}
\alias{TMTI_CTP}
\title{A Closed Testing Procedure for the TMTI using an O(n^2) shortcut}
\usage{
CTP_TMTI(
  pvals,
  alpha = 0.05,
  B = 1000,
  gammaList = NULL,
  tau = NULL,
  K = NULL,
  is.sorted = FALSE,
  EarlyStop = FALSE,
  ...
)

TMTI_CTP(
  pvals,
  alpha = 0.05,
  B = 1000,
  gammaList = NULL,
  tau = NULL,
  K = NULL,
  is.sorted = FALSE,
  ...
)
}
\arguments{
\item{pvals}{A vector of p-values.}

\item{alpha}{Level to perform each intersection test at. Defaults to 0.05.}

\item{B}{Number of bootstrap replications if gamma needs to be approximated.
Not used if specifying a list of functions using the gammaList argument
or if length(pvals) <= 100. Defaults to 1000.}

\item{gammaList}{A list of pre-specified gamma functions. If NULL, gamma
functions will be approximated via bootstrap, assuming independence. Defaults
to NULL.}

\item{tau}{Numerical (in (0,1)); threshold to use in tTMTI. If set to NULL,
then either TMTI (default) or rtTMTI is used.}

\item{K}{Integer; Number of smallest p-values to use in rtTMTI. If se to NULL,
then either TMTI (default) or tTMTI is used.}

\item{is.sorted}{Logical, indicating the p-values are pre-sorted. Defaults
to FALSE.}

\item{EarlyStop}{Logical indicating whether to exit as soon as a non-significant
p-value is found. Defaults to FALSE.}

\item{...}{Additional arguments.}
}
\value{
A data.frame containing adjusted p-values and the original index of
the p-values.
}
\description{
A Closed Testing Procedure for the TMTI using an O(n^2) shortcut
}
\examples{
## Simulate some p-values
## The first 10 are from false hypotheses, the next 10 are from true
pvals = c(
  rbeta(10, 1, 20), ## Mean value of .05
  runif(10)
)
CTP_TMTI(pvals)

}
