# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Leading NA
#'
#' Returns the TMTI_infinity statistic from pre-sorted,
#' pre-truncated vector of p-values. If no truncation is used, set m_full = m
#'
#' @param pvals A NumericVector containing the truncated sorted p-values. It
#' is important that this vector: 1) contains only the truncated p-values (i.e,
#' those that fall below the truncation point) and 2) is sorted.
#' @param m The total (i.e., non-truncated) number of p-values.
MakeZ_C <- function(pvals, m) {
    .Call('_TMTI_MakeZ_C', PACKAGE = 'TMTI', pvals, m)
}

#' Leading NA
#'
#' Returns the transformed p-values (Y) from pre-sorted p-values and
#' pre-truncated p-values. If not truncation is used, set m_full = m
#'
#' @param pvals A NumericVector containing the truncated sorted p-values. It
#' is important that this vector: 1) contains only the truncated p-values (i.e,
#' those that fall below the truncation point) and 2) is sorted.
#' @param m The total (i.e., non-truncated) number of p-values.
MakeY_C <- function(pvals, m) {
    .Call('_TMTI_MakeY_C', PACKAGE = 'TMTI', pvals, m)
}

#' Leading NA
#'
#' Returns the transformed p-values (Y) from pre-sorted p-values and
#' pre-truncated p-values when n < m - 1
#'
#' @param pvals A NumericVector containing the truncated sorted p-values. It
#' is important that this vector: 1) contains only the truncated p-values (i.e,
#' those that fall below the truncation point) and 2) is sorted.
#' @param n A positive number (or Inf) indicating which type of local minimum
#' to consider. Defaults to Infm, corresponding to the global minimum.
#' @param m The total (i.e., non-truncated) number of p-values.
MakeZ_C_nsmall <- function(pvals, n, m) {
    .Call('_TMTI_MakeZ_C_nsmall', PACKAGE = 'TMTI', pvals, n, m)
}

#' Leading NA
#'
#' Tests a user-specified subset in a CTP, using a user-supplied local test
#'
#'
#' @param LocalTest A function that returns a double in (0, 1).
#' @param pSub A vector with the p-values of the set to be tested.
#' @param pRest A vector containing the remaining p-values.
#' @param alpha Double indicating the significance level.
#' @param is_subset_sequence Logical indicating whether the supplied subset of
#' p_values corresponds to the pSub.size() smallest overall p-values.
#' @param EarlyStop Logical indicating whether to exit as soon as a non-significant
#' p-value is found.
#' @param verbose Logical indicating whether to print progress.
TestSet_C <- function(LocalTest, pSub, pRest, alpha, is_subset_sequence, EarlyStop, verbose) {
    .Call('_TMTI_TestSet_C', PACKAGE = 'TMTI', LocalTest, pSub, pRest, alpha, is_subset_sequence, EarlyStop, verbose)
}

#' Leading NA
#'
#' Tests a user-specified subset in a CTP, using a user-supplied local test
#'
#'
#' @param LocalTest A function that returns a double in (0, 1).
#' @param f A function that iterates LocalTest over the relevant test tree.
#' In practice, this is called as TestSet_C.
#' @param pvals A vector of p-values.
#' @param EarlyStop Logical indicating whether to exit as soon as a non-significant
#' p-value is found.
#' @param alpha Significance level. This is only used if EarlyStop = TRUE
FullCTP_C <- function(LocalTest, f, pvals, EarlyStop, alpha) {
    .Call('_TMTI_FullCTP_C', PACKAGE = 'TMTI', LocalTest, f, pvals, EarlyStop, alpha)
}

#' Leading NA
#'
#' Computes a confidence set for the number of false hypotheses among all hypotheses
#'
#'
#' @param LocalTest A function that returns a double in (0, 1).
#' @param pvals A vector of p-values.
#' @param alpha A double indicating the significance level
TopDown_C <- function(LocalTest, pvals, alpha) {
    .Call('_TMTI_TopDown_C', PACKAGE = 'TMTI', LocalTest, pvals, alpha)
}

#' Leading NA
#'
#' Computes a confidence set for the number of false hypotheses among all hypotheses
#' using a binary search
#'
#'
#' @param LocalTest A function that returns a double in (0, 1).
#' @param pvals A vector of p-values.
#' @param alpha A double indicating the significance level
#' @param low integer denoting the starting point for the search. Should start at zero.
#' @param high integer denoting the end point of the search. Should end at pvals.size() - 1.
#' @param verbose boolean, indicating whether to print progress.
TopDown_C_binary <- function(LocalTest, pvals, alpha, low, high, verbose) {
    .Call('_TMTI_TopDown_C_binary', PACKAGE = 'TMTI', LocalTest, pvals, alpha, low, high, verbose)
}

#' Leading NA
#'
#' Computes a confidence set for the number of false hypotheses among a subset of
#' using a binary search
#'
#'
#' @param LocalTest A function that returns a double in (0, 1).
#' @param pSub A vector of p-values from the subset of interest.
#' @param pRest A vector of the remaining p-values.
#' @param alpha A double indicating the significance level
#' @param low integer denoting the starting point for the search. Should start at zero.
#' @param high integer denoting the end point of the search. Should end at pvals.size() - 1.
#' @param verbose boolean, indicating whether to print progress.
TopDown_C_binary_subset <- function(LocalTest, pSub, pRest, alpha, low, high, verbose) {
    .Call('_TMTI_TopDown_C_binary_subset', PACKAGE = 'TMTI', LocalTest, pSub, pRest, alpha, low, high, verbose)
}

#' Leading NA
#'
#' Computes a confidence set for the number of false hypotheses among a subset of
#' using a binary search
#'
#'
#' @param LocalTest A function that returns a double in (0, 1).
#' @param pvals A vector of p-values.
#' @param k integer denoting the k to control the kFWER at.
#' @param alpha A double indicating the significance level
#' @param low integer denoting the starting point for the search. Should start at zero.
#' @param high integer denoting the end point of the search. Should end at pvals.size() - 1.
#' @param verbose boolean, indicating whether to print progress.
#' @return The number of hypotheses that can be rejected with kFWER control at a user
#' specific k.
kFWER_set_C <- function(LocalTest, pvals, k, alpha, low, high, verbose) {
    .Call('_TMTI_kFWER_set_C', PACKAGE = 'TMTI', LocalTest, pvals, k, alpha, low, high, verbose)
}

#' Leading NA
#'
#' Computes a the number of hypotheses that can be rejected with FWER control by
#' using a binary search
#'
#'
#' @param LocalTest A function that returns a double in (0, 1).
#' @param pvals A vector of p-values.
#' @param alpha A double indicating the significance level
#' @param low integer denoting the starting point for the search. Should start at zero.
#' @param high integer denoting the end point of the search. Should end at pvals.size() - 1.
#' @param verbose boolean, indicating whether to print progress.
#' @return The number of hypotheses that can be rejected with kFWER control at a user
#' specific k.
FWER_set_C <- function(LocalTest, pvals, alpha, low, high, verbose) {
    .Call('_TMTI_FWER_set_C', PACKAGE = 'TMTI', LocalTest, pvals, alpha, low, high, verbose)
}

