% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMB.R
\name{precompile}
\alias{precompile}
\title{Precompile the TMB library in order to speed up compilation of templates.}
\usage{
precompile(all = TRUE, clean = FALSE, trace = TRUE, ...)
}
\arguments{
\item{all}{Precompile all or just the core parts of TMB ?}

\item{clean}{Remove precompiled libraries ?}

\item{trace}{Trace precompilation process ?}

\item{...}{Not used.}
}
\description{
Precompile the TMB library
}
\details{
Precompilation can be used to speed up compilation of
templates. It is only necessary to run \code{precompile()} once,
typically right after installation of TMB. The function
\emph{prepares} TMB for precompilation, while the actual
pre-compilation takes place the first time you compile a model
after running \code{precompile()}.

Note that the precompilation requires write access to the TMB
package folder. Three versions of the library will be prepared:
Normal, parallel and a debugable version.

Precompilation works the same way on all platforms. The only known
side-effect of precompilation is that it increases the file size
of the generated binaries.
}
\examples{
\dontrun{
## Prepare precompilation
precompile()
## Perform precompilation by running a model
runExample(all = TRUE)
}
}

