% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chMDB.R, R/fileMDB.R, R/generics.R,
%   R/memoMDB.R, R/metaMDB.R
\name{filter_mdb_matrix.chMDB}
\alias{filter_mdb_matrix.chMDB}
\alias{filter_mdb_matrix.fileMDB}
\alias{filter_mdb_matrix}
\alias{filter_mdb_matrix.memoMDB}
\alias{filter_mdb_matrix.metaMDB}
\title{Filter a matrix stored in an MDB}
\usage{
\method{filter_mdb_matrix}{chMDB}(x, tableName, ...)

\method{filter_mdb_matrix}{fileMDB}(x, tableName, .by = 10^5, ...)

filter_mdb_matrix(x, tableName, ...)

\method{filter_mdb_matrix}{memoMDB}(x, tableName, ...)

\method{filter_mdb_matrix}{metaMDB}(x, tableName, ...)
}
\arguments{
\item{x}{an \link{MDB} object}

\item{tableName}{a character vector of length 1 corresponding to the name of
the table to filter (must be a matrix)}

\item{...}{character vectors with the row names and/or columns names to
select. The names of the parameters must correspond to the name of the
column and of the row fields (the matrix cannot be filtered from values).}

\item{.by}{the size of the batch: number of lines to process
together (default: 10000)}
}
\value{
A sub-matrix of tableName in x. Only existing elements are returned.
No error is raised if any element is missing. The result must be checked
and adapted to user needs.
}
\description{
Filter a matrix stored in an MDB
}
\examples{
\dontrun{
## Return the matrix of expression values focused on the selected genes
filter_mdb_matrix(x=db, "Expression_value", gene=c("SNCA", "MAPT"))
}

}
