% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pex_acf.R
\name{pex_acf}
\alias{pex_acf}
\title{Power-exponential autocorrelation function.}
\usage{
pex_acf(tseq, lambda, rho)
}
\arguments{
\item{tseq}{Vector of \code{N} time points at which the autocorrelation is to be calculated.}

\item{lambda}{Timescale parameter.}

\item{rho}{Power parameter.}
}
\value{
An autocorrelation vector of length \code{N}.
}
\description{
Power-exponential autocorrelation function.
}
\details{
The power-exponential autocorrelation function is given by:
\deqn{
\mathrm{\scriptsize ACF}(t) = \exp \left\{-(t/\lambda)^\rho\right\}.
}{
acf(t) = exp (-(t / \lambda)^\rho).
}
}
\examples{
pex_acf(tseq = 1:10, lambda = 1, rho = 2)
}
