% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ElasticNet_HJBiplot.R
\name{ElasticNet_HJBiplot}
\alias{ElasticNet_HJBiplot}
\title{Elastic Net HJ Biplot}
\usage{
ElasticNet_HJBiplot(X, Lambda = 1e-04, Alpha = 1e-04, Transform.Data = 'scale')
}
\arguments{
\item{X}{array_like; \cr
A data frame with the information to be analyzed}

\item{Lambda}{float; \cr
Tuning parameter of the LASSO penalty. Higher values lead to sparser components.}

\item{Alpha}{float; \cr
Tuning parameter of the Ridge shrinkage}

\item{Transform.Data}{character; \cr
A value indicating whether the columns of X (variables) should be centered or scaled. Options are: "center" that removes the columns means and "scale" that removes the columns means and divide by its standard deviation. Default is "scale".}
}
\value{
\code{ElasticNet_HJBiplot} returns a list containing the following components:
\item{loadings}{  array_like; \cr
          penalized loadings, the loadings of the sparse principal components.
          }

\item{n_ceros}{  array_like; \cr
          number of loadings equal to cero in each component.
          }

\item{coord_ind}{  array_like; \cr
          matrix with the coordinates of individuals.
          }

\item{coord_var}{  array_like; \cr
          matrix with the coordinates of variables.
          }

\item{eigenvalues}{  array_like; \cr
          vector with the eigenvalues penalized.
          }

\item{explvar}{  array_like; \cr
          an vector containing the proportion of variance explained by the first 1, 2,.,k sparse principal components obtained.
          }
}
\description{
This function is a generalization of the Ridge regularization method and the LASSO penalty. Realizes the representation of the SPARSE HJ Biplot through a combination of LASSO and Ridge, on the data matrix. This means that with this function you can eliminate weak variables completely as with the LASSO regularization or contract them to zero as in Ridge.
}
\details{
Algorithm used to perform automatic selection of variables and continuous contraction simultaneously. With this method, the model obtained is simpler and more interpretable. It is a particularly useful method when the number of variables is much greater than the number of observations.
}
\examples{
 ElasticNet_HJBiplot(mtcars, Lambda = 0.2, Alpha = 0.1)

}
\references{
\itemize{
 \item Galindo, M. P. (1986). Una alternativa de representacion simultanea: HJ-Biplot. Questiio, 10(1), 13-23.
 \item Erichson, N. B., Zheng, P., Manohar, K., Brunton, S. L., Kutz, J. N., & Aravkin, A. Y. (2018). Sparse principal component analysis via variable projection. arXiv preprint arXiv:1804.00341.
 \item Zou, H., & Hastie, T. (2005). Regularization and variable selection via the elastic net. Journal of the royal statistical society: series B (statistical methodology), 67(2), 301-320.
}
}
\seealso{
\code{[elasticnet]{spca}}, \code{\link{Plot_Biplot}}
}
\author{
Mitzi Cubilla-Montilla, Carlos Torres-Cubilla, Ana Belen Nieto Librero and Purificacion Galindo Villardon
}
