% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{AddMotifObject}
\alias{AddMotifObject}
\alias{AddMotifObject.Assay}
\alias{AddMotifObject.Seurat}
\title{Add a Motif object to a Seurat object}
\usage{
AddMotifObject(object, ...)

\method{AddMotifObject}{Assay}(object, motif.object, verbose = TRUE, ...)

\method{AddMotifObject}{Seurat}(object, motif.object, assay = NULL, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Additional arguments}

\item{motif.object}{An object of class Motif}

\item{verbose}{Display messages}

\item{assay}{Name of assay to store motif object in}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object
}
\description{
Add a Motif object to a Seurat object
}
\examples{
obj <- GetMotifObject(atac_small[['peaks']])
atac_small[['peaks']] <- AddMotifObject(
object = atac_small[['peaks']], motif.object = obj
)
obj <- GetMotifObject(object = atac_small)
atac_small[['peaks']] <- AddMotifObject(
object = atac_small, motif.object = obj
)
}
