% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_boxplot.R
\name{raw_boxplot}
\alias{raw_boxplot}
\alias{raw_boxplot.swmpr}
\title{Boxplots of raw data by user-defined season for a target year}
\usage{
raw_boxplot(swmpr_in, ...)

\method{raw_boxplot}{swmpr}(
  swmpr_in,
  param = NULL,
  target_yr = NULL,
  criteria = NULL,
  free_y = FALSE,
  log_trans = FALSE,
  converted = FALSE,
  plot_title = FALSE,
  ...
)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods. See \code{\link{assign_season}} and \code{\link{y_labeler}}.}

\item{param}{chr string of variable to plot}

\item{target_yr}{numeric, if target year is not specified then all data in the data frame will be used.}

\item{criteria}{numeric, a numeric criteria that will be plotted as a horizontal line}

\item{free_y}{logical, should the y-axis be free? Defaults to \code{FALSE}. If \code{FALSE}, defaults to zero, unless negative values are present. If \code{TRUE}, y-axis limits are selected by \code{ggplot}}

\item{log_trans}{logical, should y-axis be log? Defaults to \code{FALSE}}

\item{converted}{logical, were the units converted from the original units used by CDMO? Defaults to \code{FALSE}. See \code{y_labeler} for details.}

\item{plot_title}{logical, should the station name be included as the plot title? Defaults to \code{FALSE}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Boxplots of raw data by user-defined season for a target year
}
\details{
This function produces boxplots of raw, unaggregated data by user-specified season for year of interest
}
\examples{
\dontshow{
data(apacpwq)

dat <- qaqc(apacpwq, qaqc_keep = c('0', '3', '5'))

y <- raw_boxplot(dat, param = 'do_mgl')
}

\donttest{
## get data, prep
data(elksmwq)
dat <- elksmwq

dat <- qaqc(elksmwq, qaqc_keep = c('0', '3', '5'))
raw_boxplot(dat, param = 'do_mgl')

}

}
\seealso{
\code{\link[ggplot2]{ggplot}}, \code{\link{assign_season}}, \code{\link{y_labeler}}
}
\author{
Julie Padilla
}
\concept{analyze}
