% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ticker.R
\name{make_ticker}
\alias{make_ticker}
\title{Make date ticker}
\usage{
make_ticker(
  date_min = 19000101,
  date_max = as.integer(gsub("-", "", as.Date(Sys.Date())))
)
}
\arguments{
\item{date_min}{Start date, in YYYYMMDD format. Default is \code{19000101}. Integer.}

\item{date_max}{End date, in YYYYMMDD format. Default is today. Integer.}
}
\value{
\code{data.table} object, with seven columns:
\itemize{
 \item \code{DATE}. Date in YYYYMMDD format. Integer.
 \item \code{DATE_ALT}. Date in \code{Date} (YYYY-MM-DD) format. Date.
 \item \code{TID}. Date ID, in consecutive integer format. Integer.
 \item \code{YRWK}. Week in YYYYWW format. Integer.
 \item \code{WID}. Weed ID, in consecutive integer format. Integer.
 \item \code{YRMO}. Month in YYYYMM format. Integer.
 \item \code{MID}. Month ID, in consecutive integer format. Integer.
 \item \code{YEAR}. Year in YYYY format. Integer.
}
}
\description{
Function to create a table of consecutive dates, in SUNGEO-compliant format.
}
\examples{
# All dates from January 1, 1900 to today
\dontrun{
out_1 <- make_ticker()
out_1
}

# All dates from January 1, 1200 to today
\dontrun{
out_2 <- make_ticker(date_min=12000101)
out_2
}
 
# All dates from January 1, 1500 to December 31, 1899
\dontrun{
out_3 <- make_ticker(date_min=15000101, date_max=18991231)
out_3
}
}
