% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{get_info}
\alias{get_info}
\title{Information on available SUNGEO data files}
\usage{
get_info(country_names = NULL, country_iso3s = NULL, topics = NULL)
}
\arguments{
\item{country_names}{Country name(s). Character string (single country) or vector of character strings (multiple countries).}

\item{country_iso3s}{Country code (ISO 3166-1 alpha-3). Character string (single country) or vector of character strings (multiple countries).}

\item{topics}{Data topics. See \code{get_info()} for full list. Character string (single topic) or vector of character strings (multiple topics).}
}
\value{
list object, with three slots: 'summary', 'topics', and 'geoset'.
}
\description{
This function reports the availability of data files on the SUNGEO server, searchable by country and topic.
}
\examples{
# Get list of all available data
\dontrun{
out_1 <- get_info()
out_1["summary"]
out_1["topics"]
out_1["geosets"]
}

# Get list of available data for a single country
\dontrun{
out_2 <- get_info(country_names="Afghanistan")
out_2
}

# Get list of available data for a single topic
\dontrun{
out_3 <- get_info(topics="Elections:LowerHouse:CLEA")
out_3
}

# Get list of available data for a multiple countries and topics
\dontrun{
out_4 <- get_info(
                 country_names=c("Afghanistan","Zambia"),
                 topics=c("Elections:LowerHouse:CLEA","Events:PoliticalViolence:GED"))
out_4
}
}
\seealso{
\code{\link{get_data}}
}
