% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifyAlleleDataset.R
\name{verifyAlleleDataset}
\alias{verifyAlleleDataset}
\title{Verifies the allele entered is present in specified dataset}
\usage{
verifyAlleleDataset(allele, filename, alignments)
}
\arguments{
\item{allele}{An allele name written in the IPD-IMGT/HLA Database format.}

\item{filename}{The full file path of the user specified dataset if the user wishes to use their own file, or the pre-bundled Solberg dataset. User provided datasets must be a .dat, .txt, or.csv file, and must conform to the structure and format of the Solberg dataset.}

\item{alignments}{A list object of sub-lists of data frames of protein alignments for the HLA and HLA-region genes supported in the ANHIG/IMGTHLA GitHub Repository. Alignments will always be the most recent version IPD-IMGT/HLA Database version.}
}
\value{
TRUE if the allele is present in the specified data set, and the filtered allele dataset. If a user enters an allele with more than two fields and has selected the Solberg dataset as the data source, a message informing the user that the allele has been truncated is appended to the output. If an allele entered is valid, but is not present in the user provided dataset, a warning message is returned.
}
\description{
Verifies the allele entered is present in the specified dataset.
}
\note{
For internal SSHAARP use only.
}
