% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkLocusDataset.R
\name{checkLocusDataset}
\alias{checkLocusDataset}
\title{Check locus validity and if the locus is present in the user specified dataset}
\usage{
checkLocusDataset(variant, filename)
}
\arguments{
\item{variant}{An allele or an amino acid motif in the following format: Locus*##$~##$~##$, where ## identifies a peptide position, and $ identifies an amino acid residue. Motifs can include any number of amino acids. Haplotypes must contain alleles that follow the aforementioned format, and may be delimited by "~" or "-".}

\item{filename}{The full file path of the user specified dataset if the user wishes to use their own file, or the pre-bundled Solberg dataset or mock haplotype dataset. User provided datasets must be a .dat, .txt, or.csv file, and must conform to the structure and format of the datasets bundled with the package. Allele and motif datasets should follow the Solberg dataset format, and haplotype datasets should follow the SSHAARP haplotype mock data format.}
}
\value{
TRUE if locus is a protein-coding gene and is in the specified dataset. Otherwise, a vector with FALSE and an error message is returned.
}
\description{
Checks if the locus in the entered variant is a protein-coding gene annotated by the IPD-IMGT/HLA Database, and if it is in the user specified dataset.
}
\note{
For internal SSHAARP use only.
}
