% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\name{getShapeMSI,msi.dataset-method}
\alias{getShapeMSI,msi.dataset-method}
\alias{getShapeMSI}
\title{Returns the geometrical shape of MSI dataset}
\usage{
\S4method{getShapeMSI}{msi.dataset}(object)
}
\arguments{
\item{object}{\link{msi.dataset-class} object.}
}
\value{
number of rows ans number of columns of the MS image.
}
\description{
Returns the geometrical shape of MSI dataset
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2] * 20), sz[1] * sz[2], 20)
x[x < 0] <- 0
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Get m/z vector
mz <- getMZ(msiX)

## Get intensity matrix
X <- getIntensityMat(msiX)

## Get image size
sz <- getShapeMSI(msiX)
}
