% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\docType{methods}
\name{binKmeans,msi.dataset-method}
\alias{binKmeans,msi.dataset-method}
\alias{binKmeans}
\title{Return a binary mask generated applying k-means clustering
on peaks intensities.}
\usage{
\S4method{binKmeans}{msi.dataset}(object)
}
\arguments{
\item{object}{\link{msi.dataset-class} object}
}
\value{
\link{ms.image-class} object representing the binary mask image.
}
\description{
Return a binary mask generated applying k-means clustering
on peaks intensities.
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(5, 4)
x <- matrix(rnorm(sz[1] * sz[2]), sz[1], sz[2])
mz <- seq(100, 195, 5)
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Binarize the reference image
refBin <- binKmeans(msiX)
}
