% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEQuential.R
\name{SEQuential}
\alias{SEQuential}
\title{SEQuential trial emulation}
\usage{
SEQuential(
  data,
  id.col,
  time.col,
  eligible.col,
  treatment.col,
  outcome.col,
  time_varying.cols = list(),
  fixed.cols = list(),
  method,
  options,
  verbose = TRUE
)
}
\arguments{
\item{data}{data.frame or data.table, if not already expanded with \code{SEQexpand}, will preform expansion according to arguments passed to either \code{params} or \code{...}}

\item{id.col}{String: column name of the id column}

\item{time.col}{String: column name of the time column}

\item{eligible.col}{String: column name of the eligibility column}

\item{treatment.col}{String: column name of the treatment column}

\item{outcome.col}{String: column name of the outcome column}

\item{time_varying.cols}{List: column names for time varying columns}

\item{fixed.cols}{List: column names for fixed columns}

\item{method}{String: method of analysis to preform}

\item{options}{List: optional list of parameters from \code{SEQopts}}

\item{verbose}{Logical: if TRUE, cats progress to console}
}
\value{
An S4 object of class SEQoutput
}
\description{
`SEQuential` is an all-in-one API to SEQuential analysis, returning a SEQoutput object of results. More specific examples can be found on pages at https://causalinference.github.io/SEQuential/
}
\details{
Implemention of sequential trial emulation for the analysis of observational databases. 
The SEQuential software accommodates time-varying treatments and confounders, as well as binary 
and failure time outcomes. SEQ allows to compare both static and dynamic strategies, 
can be used to estimate observational analogs of intention-to-treat 
and per-protocol effects, and can adjust for potential selection bias induced by losses-to-follow-up.
}
\examples{
\donttest{
data <- SEQdata
model <- SEQuential(data, id.col = "ID", 
                          time.col = "time", 
                          eligible.col = "eligible",
                          treatment.col = "tx_init",
                          outcome.col = "outcome",
                          time_varying.cols = c("N", "L", "P"),
                          fixed.cols = "sex",
                          method = "ITT", 
                          options = SEQopts())
}

}
