% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomSearch.R
\name{randomSearch}
\alias{randomSearch}
\title{Random Search}
\usage{
randomSearch(
  model,
  hypers,
  metric,
  test = NULL,
  pop = 20,
  env = NULL,
  seed = NULL
)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} or \linkS4class{SDMmodelCV} object.}

\item{hypers}{named list containing the values of the hyperparameters that
should be tuned, see details.}

\item{metric}{character. The metric used to evaluate the models, possible
values are: "auc", "tss" and "aicc".}

\item{test}{\linkS4class{SWD} object. Test dataset used to evaluate the
model, not used with aicc and \code{\linkS4class{SDMmodelCV}} objects,
default is \code{NULL}.}

\item{pop}{numeric. Size of the population, default is 20.}

\item{env}{\link[raster]{stack} containing the environmental variables, used
only with "aicc", default is \code{NULL}.}

\item{seed}{numeric. The value used to set the seed to have consistent
results, default is \code{NULL}.}
}
\value{
\linkS4class{SDMtune} object.
}
\description{
The function performs a random search in the hyperparameters space, creating
a population of random models each one with a random combination of the
provided hyperparameters values.
}
\details{
\itemize{
\item To know which hyperparameters can be tuned you can use the output
of the function \link{getTunableArgs}. Hyperparameters not included in the
\code{hypers} argument take the value that they have in the passed model.
}
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data, test = 0.2, only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet", data = train, fc = "l")

# Define the hyperparameters to test
h <- list(reg = seq(0.2, 3, 0.2), fc = c("lqp", "lqph", "lh"))

# Run the function using as metric the AUC
output <- randomSearch(model, hypers = h, metric = "auc", test = test,
                       pop = 10, seed = 25)
output@results
output@models
# Order results by highest test AUC
output@results[order(-output@results$test_AUC), ]
}
}
\author{
Sergio Vignali
}
