% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-simdata-car.R
\name{car_pb}
\alias{car_pb}
\title{Generate permuted block treatment assignments}
\usage{
car_pb(z, trt_label, trt_alc, blocksize = 4L)
}
\arguments{
\item{z}{The car_strata design matrix, as a data frame with factor variables}

\item{trt_label}{Treatment label}

\item{trt_alc}{Treatment allocation vector}

\item{blocksize}{Permuted block blocksize}
}
\value{
A vector of treatment assignments with labels from the `trt_label` argument, based on stratified permuted block randomization.
}
\description{
Generate permuted block treatment assignments
}
\examples{
# Create car_strata variables
library(fastDummies)
library(dplyr)

x <- runif(100)
z <- cut(x, breaks=c(0, 0.25, 0.5, 0.75, 1.0))
z <- dummy_cols(z) \%>\%
     mutate(across(where(is.numeric), as.factor))

car_pb(z[, 2:5], c(0, 1, 2), trt_alc=c(1/4, 1/2, 1/4), blocksize=4L)

}
