% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_image_fills.R
\name{get_image_fills}
\alias{get_image_fills}
\title{GET image fills}
\usage{
get_image_fills(file_key)
}
\arguments{
\item{file_key}{string. The key that a Figma file is referred by.}
}
\value{
This API provides a mapping from image references to download URLs
for the images. Image URLs have a 14-day maximum lifespan. Image references
are located in the output of the GET files endpoint under the `imageRef`
attribute in a Paint.
}
\description{
This API endpoint provides download URLs for all of the images
that are present in a document's image fills. Figma represents any
user-supplied images using image fills. When you drag a picture into
Figma, it builds a rectangle with a single fill to represent it. The user
can then modify the attributes of the fill and change the rectangle as they
see fit.
}
\examples{
\dontshow{if (Sys.getenv("FIGMA_ACCESS_TOKEN") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
#navigate to  file and get key from url
file_key <- "sFHgQh9dL6369o5wrZHmdR"
get_image_fills(file_key)
}
\dontshow{\}) # examplesIf}
}
