% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freconstruct.R
\name{freconstruct}
\alias{freconstruct}
\title{Reconstruction Stage of Functional Singular Spectrum Analysis}
\usage{
freconstruct(U, groups = as.list(1L:10L))
}
\arguments{
\item{U}{an object of class \code{\link{fssa}}.}

\item{groups}{a list of numeric vectors, each vector includes indices
of elementary components of a group used for reconstruction.}
}
\value{
A named list of objects of class \code{\link{funts}} that are
reconstructed according to the specified groups and a numeric vector
of eigenvalues.
}
\description{
Reconstruct univariate or multivariate functional time series
(\code{\link{funts}}) objects from functional singular spectrum analysis
(\code{\link{fssa}}) objects, including Grouping and Hankelization steps.
This function performs the reconstruction step for either univariate
functional singular spectrum analysis (ufssa) or multivariate
functional singular spectrum analysis (mfssa), depending on the input.
}
\note{
Refer to \code{\link{fssa}} for an example on how to run this
function starting from \code{\link{fssa}} objects.
}
\examples{

data("Callcenter")
L <- 28
U <- fssa(Callcenter, L)

# FSSA Reconstruction step:
gr <- list(1, 2:3, 4:5, 6:7, 1:7)
Q <- freconstruct(U, gr)
plot(Q[[1]],
  main = "Call Center Mean Component")
plot(Q[[2]],
  main = "Call Center First Periodic Component")

#--------------- Multivariate FSSA Example on bivariate -----------------------------
## temperature curves and smoothed images of vegetation
\dontrun{
data("Montana")
L <- 45
U <- fssa(Montana, L)

# MFSSA Reconstruction step:
Q <- freconstruct(U = U, groups = list(1, 2, 3))
plotly_funts(Q[[1]],
  main = c("Temperature Curves Mean", "NDVI Images Mean"),
  color_palette = "RdYlGn",
  xticklabels = list(
    c("00:00", "06:00", "12:00", "18:00", "24:00"),
    c("113.40\u00B0 W", "113.30\u00B0 W")
  ),
  xticklocs = list(c(1, 6, 12, 18, 24), c(1, 33)),
  yticklabels = list(NA, c("48.70\u00B0 N", "48.77\u00B0 N")),
  yticklocs = list(NA, c(1, 33))
) # mean

plotly_funts(Q[[2]],
  main = c("Temperature Curves Periodic", "NDVI Images Periodic"),
  color_palette = "RdYlGn",
  xticklabels = list(
    c("00:00", "06:00", "12:00", "18:00", "24:00"),
    c("113.40\u00B0 W", "113.30\u00B0 W")
  ),
  xticklocs = list(c(1, 6, 12, 18, 24), c(1, 33)),
  yticklabels = list(NA, c("48.70\u00B0 N", "48.77\u00B0 N")),
  yticklocs = list(NA, c(1, 33))
) # periodic

plot(Q[[3]],
  obs = 3,
  main = c("Temperature Curves Trend", "NDVI Images Trend,")
) # trend
}

}
\seealso{
\code{\link{fssa}}, \code{\link{funts}}
}
