% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construction.R
\name{Rd_tag}
\alias{Rd_tag}
\title{Create an Rd tag container}
\usage{
Rd_tag(tag, ..., content = Rd(...), opt = NULL,
  indent = getOption("Rd::indent", FALSE),
  indent.with = getOption("Rd::indent.with", "  "), .check = NA,
  verbose = getOption("Rd::verbose", getOption("verbose", FALSE)))
}
\arguments{
\item{tag}{The Rd/LaTeX tag to use.  Must start with the backslash.}

\item{..., content}{The content specified in individual form or list form.
Either may be used but not both.}

\item{opt}{Options for the tag which as placed in square brackets.}

\item{indent}{Should content inside the tag be indented?}

\item{indent.with}{Amount to indent with, defaults to four spaces.}

\item{.check}{Should the content be checked for valid Rd and if options are valid?
A value of FALSE indicates no checking,
TRUE strict checking and
NA convert where possible, with messages and warnings.}

\item{verbose}{Print informational messages.}
}
\description{
Rd_tag containers can contain, \link[=Rd_string]{strings},
\link[=Rd]{Rd containers} and other tags.
}
\examples{
Rd_tag("\\\\bold", Rd_text("Bolded text."))
}
\seealso{
Other construction: \code{\link{Rd_string_creation}},
  \code{\link{Rd}}
}
\concept{construction}
