% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookarounds.R
\name{rx_avoid_prefix}
\alias{rx_avoid_prefix}
\alias{rx_avoid_suffix}
\title{Negative lookaround functions}
\usage{
rx_avoid_prefix(.data = NULL, value)

rx_avoid_suffix(.data = NULL, value)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{ \%>\% }}

\item{value}{Exact expression to match}
}
\description{
This function facilitates matching by providing negative assurances for surrounding symbols/groups of symbols.
It allows for building expressions that are dependent on context of occurrence.
}
\examples{
# matches any number of digits, but not preceded by "USD"
rx() \%>\%
  rx_avoid_prefix('USD') \%>\%
  rx_digit() \%>\%
  rx_one_or_more()

#matches a digit, but not followed by " dollars"
rx() \%>\%
  rx_digit() \%>\%
  rx_avoid_suffix(' dollars')

}
